/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.util.StringUtils;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Vector;

public class NetworkInfo
implements Serializable,
Cloneable,
TaskActionListener {
    static final long serialVersionUID = -1838158951972842604L;
    private String _platform = "";
    private String _computerName = "";
    private String _domainName = "";
    private String _computerDescription = "";
    private Vector _hostsAddresses = new Vector();
    private Vector _hostsNames = new Vector();
    private Vector _typeVector = new Vector();
    private Vector _destinationVector = new Vector();
    private Vector _gatewayVector = new Vector();
    private Vector _subnetMaskVector = new Vector();
    private Vector _interfaceVector = new Vector();
    private String _defaultGateway = "";
    private String _gatewayDev = "";
    private boolean _routedEnabled = false;
    private boolean _DNSEnabled = true;
    private String[] _DNSServers = new String[0];
    private String[] _DomainSuffixes = new String[0];
    private static final String TRACE_MASKT = "XSETNETT";
    private static final String TRACE_MASKF = "XSETNETF";
    private static final String TRACE_MASKD = "XSETNETD";

    public NetworkInfo() {
        Trace.trace(TRACE_MASKT, "-> NetworkInfo constructor");
        String opsys = System.getProperty("os.name");
        Trace.trace(TRACE_MASKT, "opsys = " + opsys);
        if (!opsys.substring(0, 5).equals("Linux")) {
            this._typeVector.add("Net");
            this._typeVector.add("Host");
            this._typeVector.add("Default");
            this._destinationVector.add("9.130.1.90");
            this._destinationVector.add("9.130.1.1");
            this._destinationVector.add("");
            this._gatewayVector.add("9.130.62.253");
            this._gatewayVector.add("9.130.62.252");
            this._gatewayVector.add("9.130.62.254");
            this._subnetMaskVector.add("255.255.255.0");
            this._subnetMaskVector.add("255.255.0.0");
            this._subnetMaskVector.add("");
            this._interfaceVector.add("eth0");
            this._interfaceVector.add("tr0");
            this._interfaceVector.add("any");
            this._defaultGateway = "9.130.62.253";
            this._computerName = "myhmc";
            this._domainName = "endicott.ibm.com";
            this._computerDescription = "A description of my HMC";
            this._DNSEnabled = true;
            this._DNSServers = new String[2];
            this._DNSServers[0] = "9.0.3.1";
            this._DNSServers[1] = "9.0.2.11";
            this._DomainSuffixes = new String[3];
            this._DomainSuffixes[0] = "endicott.ibm.com";
            this._DomainSuffixes[1] = "raleigh.ibm.com";
            this._DomainSuffixes[2] = "austin.ibm.com";
        }
        try {
            byte[] type = SimServer.getSimServer().readSim(5);
            if (type != null && type.length > 0) {
                switch (type[0]) {
                    case 1: {
                        this.setPlatform("SE");
                        break;
                    }
                    case 2: {
                        this.setPlatform("ZHMC");
                        break;
                    }
                    case 3: {
                        this.setPlatform("ALTSE");
                        break;
                    }
                    case 4: {
                        this.setPlatform("PHMC");
                        break;
                    }
                    default: {
                        this.setPlatform("ZHMC");
                    }
                }
                Trace.trace(TRACE_MASKF, "NetworkInfo: Platform determined: [" + this.getPlatform() + "]");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception reading SIM: " + e);
        }
        Trace.trace(TRACE_MASKT, "<- NetworkInfo constructor");
    }

    public String getPlatform() {
        return this._platform;
    }

    public void setPlatform(String platform) {
        this._platform = platform;
    }

    public static boolean isValidIPAddr(String s) {
        boolean result;
        block3: {
            result = true;
            if (null == s || (s = s.trim()).length() <= 0) break block3;
            if (!StringUtils.isValid(s, "0123456789.")) {
                result = false;
            }
            try {
                InetAddress iaddress = InetAddress.getByName(s);
            }
            catch (Exception exc) {
                result = false;
            }
        }
        return result;
    }

    public String getComputerName() {
        return this._computerName;
    }

    public void setComputerName(String computerName) {
        this._computerName = computerName;
    }

    public String getDomainName() {
        return this._domainName;
    }

    public void setDomainName(String domainName) {
        this._domainName = domainName;
    }

    public String getComputerDescription() {
        return this._computerDescription;
    }

    public void setComputerDescription(String computerDescription) {
        this._computerDescription = computerDescription;
    }

    public String getGatewayDev() {
        return this._gatewayDev;
    }

    public void setGatewayDev(String gatewayDev) {
        this._gatewayDev = gatewayDev;
    }

    public Vector getHostsAddresses() {
        return this._hostsAddresses;
    }

    public void setHostsAddresses(Vector hostsAddresses) {
        this._hostsAddresses = hostsAddresses;
    }

    public Vector getHostsNames() {
        return this._hostsNames;
    }

    public void setHostsNames(Vector hostsNames) {
        this._hostsNames = hostsNames;
    }

    public Vector getTypeVector() {
        return this._typeVector;
    }

    public void setTypeVector(Vector typeVector) {
        this._typeVector = typeVector;
    }

    public Vector getDestinationVector() {
        return this._destinationVector;
    }

    public void setDestinationVector(Vector destinationVector) {
        this._destinationVector = destinationVector;
    }

    public Vector getGatewayVector() {
        return this._gatewayVector;
    }

    public void setGatewayVector(Vector gatewayVector) {
        this._gatewayVector = gatewayVector;
    }

    public Vector getSubnetMaskVector() {
        return this._subnetMaskVector;
    }

    public void setSubnetMaskVector(Vector subnetMaskVector) {
        this._subnetMaskVector = subnetMaskVector;
    }

    public Vector getInterfaceVector() {
        return this._interfaceVector;
    }

    public void setInterfaceVector(Vector interfaceVector) {
        this._interfaceVector = interfaceVector;
    }

    public String getDefaultGateway() {
        return this._defaultGateway;
    }

    public void setDefaultGateway(String defaultGateway) {
        this._defaultGateway = defaultGateway;
    }

    public boolean isRoutedEnabled() {
        return this._routedEnabled;
    }

    public void setRoutedEnabled(boolean routedEnabled) {
        this._routedEnabled = routedEnabled;
    }

    public boolean isDNSEnabled() {
        return this._DNSEnabled;
    }

    public void setDNSEnabled(boolean DNSEnabled) {
        this._DNSEnabled = DNSEnabled;
    }

    public String[] getDNSServers() {
        return this._DNSServers;
    }

    public void setDNSServers(String[] DNSServers) {
        this._DNSServers = DNSServers;
    }

    public String[] getDomainSuffixes() {
        return this._DomainSuffixes;
    }

    public void setDomainSuffixes(String[] DomainSuffixes) {
        this._DomainSuffixes = DomainSuffixes;
    }

    public void actionPerformed(TaskActionEvent e) {
    }
}

